//
//  MCPortsDeamon.h
//  MCClientServer
//
//  Created by Thomas Bartelmess on 01.03.10.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import "MCPortsDeamonDefines.h"
#import "MCPGDaemon.h"
#import "MCNetworkWatcherDelegateProtocol.h"
#import <MCCloud/MCCloud.h>
//#import <MCFoundation/MCFoundation.h>
#import <MCServerSupport/MCServerKeychain.h>

@class MCPortMappingManager;
@class MCNetworkWatcher;

@interface MCPortsDeamon : MCPGDaemon <MCCIPUpdaterDelegate, MCRestRequestCredentialsProvider, MCNetworkWatcherDelegate> {
	@private
		MCCIPUpdater* ipUpdater;
		MCServerKeychain * cloudKeychain;

		NSTimer * ipUpdateTimer;
		MCPortsdOperationMode operationMode;
		MCPortMappingManager *mappingManager;
		MCNetworkWatcher *networkWatcher;
}

+ (NSString *)cloudApplicationIdentifier;
- (NSString *)cloudApplicationIdentifier;
- (void)annouceChanges;

+ (NSString *)keychainPath;
- (NSString *)keychainPath;
- (void)updateIPOnMCCloud;
@property (nonatomic, retain) MCCIPUpdater* ipUpdater;
@property (nonatomic, retain) MCServerKeychain * cloudKeychain;
@property (nonatomic, retain) NSTimer * ipUpdateTimer;
@property (nonatomic, retain) MCNetworkWatcher *networkWatcher;
@property (nonatomic, readonly) MCPortsdOperationMode operationMode;
@end 
